// force-language.js — run at document_start to ensure default language is English
(function(){
  try {
    const LANG = 'en-US';
    // Set chrome.storage if available (async)
    if (typeof chrome !== 'undefined' && chrome.storage && chrome.storage.local) {
      try {
        chrome.storage.local.get(['language'], function(res){
          if (!res || !res.language) {
            chrome.storage.local.set({ language: LANG }, function(){ /* ok */ });
          }
        });
      } catch(e){}
    }
    // Set localStorage immediately for scripts that read it synchronously
    try {
      if (!localStorage.getItem('language')) {
        localStorage.setItem('language', LANG);
      }
    } catch(e){}
    // Also set navigator language override polyfill for scripts that check navigator.language (best-effort)
    try {
      Object.defineProperty(navigator, 'language', { get: function(){ return 'en-US'; }, configurable: true });
      Object.defineProperty(navigator, 'languages', { get: function(){ return ['en-US', 'en']; }, configurable: true });
    } catch(e){}
  } catch(err){
    // ignore
  }
})();